function [slice, int_x, int_y] = SliceData(point,angle,length,Image,numpoints,doublesided)
%Shawn Irgen-Gioro 4/26/22
%this function takes slices of a 2D dataset along a line that is centered
%at "point" (x,y) at "angle" in degrees. The slice is returned through
%interpolation. The function requires at least 4 inputs. If you would like,
%you can specify how long the vector will be. Currently, is written in
%units of pixels. Interpolation is linear.

%outputs are the interpolated slice. optional output is the x/y values that
%are interpolated over. Most likely will not be that interesting, but may
%be helpful if you are plotting the line to confirm you're slicing what you
%think you're slicing.


if doublesided
        Lx1=point(1)-(length*cosd(angle));
        Ly1=point(2)-(length*sind(angle));
else
        Lx1=point(1);
        Ly1=point(2);
end
        Lx2=point(1)+(length*cosd(angle));
        Ly2=point(2)+(length*sind(angle));
        
        coefficients = polyfit([Lx1, Lx2], [Ly1, Ly2], 1);
        a = coefficients (1);
        b = coefficients (2);
        
        int_x = linspace(Lx1,Lx2,numpoints);
        int_y = a.*int_x+b;
        
%         plot(int_x,int_y,'Color',clim(jj,:))
        
        slice = interp2(1:size(Image,1),1:size(Image,2),Image,...
            int_x,int_y);

end